/*
 * Decompiled with CFR 0.152.
 */
package somcolorapp;

import baseui.CaboutBox;
import baseui.Calert;
import baseui.Cui;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import somcolorapp.ReseauSOMColor;
import somcolorapp.SOMColor;
import somcolorapp.SOMColorProcess;

public class SOMColorUI
extends Cui {
    public SOMColor applet;
    public SOMColorProcess processSOM;
    public int tailleReseau;
    public int maxIterations;
    public int nbCouleurs;
    public double eta0;
    public double sigma0;
    Label statusBar = new Label();
    Panel panel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    Panel panel2 = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    Button btnReset = new Button();
    Button btnAbout = new Button();
    Button btnGo = new Button();
    Button btnPas = new Button();
    Panel panelVue = new Panel();
    GridLayout gridLayout2 = new GridLayout();
    Panel panel3 = new Panel();
    TextField txtTaille = new TextField();
    Label label1 = new Label();
    Label label2 = new Label();
    TextField txtCouleurs = new TextField();
    Label label3 = new Label();
    TextField txtIterations = new TextField();
    GridLayout gridLayout3 = new GridLayout();
    Label label4 = new Label();
    TextField txtEta0 = new TextField();
    Label label5 = new Label();
    TextField txtSigma0 = new TextField();
    Button btnModif = new Button();

    public SOMColorUI(SOMColor sOMColor, int n) {
        this.applet = sOMColor;
        this.enableEvents(64L);
        this.processSOM = new SOMColorProcess(this);
        this.process = this.processSOM;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(this.applet.comments + " " + this.applet.version + " " + this.applet.auteur);
        this.statusBar.setText(" It\u00e9ration :");
        this.panel1.setLayout(this.borderLayout1);
        this.panel2.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(4);
        this.gridLayout1.setHgap(0);
        this.btnReset.setLabel("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SOMColorUI.this.btnReset_actionPerformed(actionEvent);
            }
        });
        this.btnAbout.setLabel("A propos");
        this.btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SOMColorUI.this.btnAbout_actionPerformed(actionEvent);
            }
        });
        this.btnGo.setLabel("GO");
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SOMColorUI.this.btnGo_actionPerformed(actionEvent);
            }
        });
        this.btnPas.setLabel("Pas \u00e0 Pas");
        this.btnPas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SOMColorUI.this.btnPas_actionPerformed(actionEvent);
            }
        });
        this.panelVue.setLayout(this.gridLayout2);
        this.panelVue.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SOMColorUI.this.panelVue_componentResized(componentEvent);
            }
        });
        this.label1.setAlignment(1);
        this.label1.setText("Taille^1/2");
        this.label2.setAlignment(1);
        this.label2.setText("Nb couleurs^1/3");
        this.txtCouleurs.setEnabled(false);
        this.txtCouleurs.setText(Integer.toString(ReseauSOMColor.NB_COL_DEF));
        this.label3.setAlignment(1);
        this.label3.setLocale(Locale.getDefault());
        this.label3.setText("It\u00e9rations");
        this.txtIterations.setEnabled(false);
        this.txtIterations.setText(Integer.toString(ReseauSOMColor.MAX_ITER_DEF));
        this.panel3.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(11);
        this.label4.setAlignment(1);
        this.label4.setText("Eta0");
        this.txtEta0.setEnabled(false);
        this.txtEta0.setText(Double.toString(ReseauSOMColor.ETA0_DEF));
        this.label5.setAlignment(1);
        this.label5.setText("Sigma0");
        this.txtSigma0.setEnabled(false);
        this.txtSigma0.setText(Double.toString(ReseauSOMColor.SIGMA0_DEF));
        this.txtTaille.setEnabled(false);
        this.txtTaille.setText(Integer.toString(ReseauSOMColor.TAILLE_DEF));
        this.btnModif.setLabel("Modif.");
        this.btnModif.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SOMColorUI.this.btnModif_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.panel2, "South");
        this.panel2.add((Component)this.btnReset, null);
        this.panel2.add((Component)this.btnGo, null);
        this.panel2.add((Component)this.btnPas, null);
        this.panel2.add((Component)this.btnAbout, null);
        this.panel1.add((Component)this.panelVue, "Center");
        this.add((Component)this.panel3, "North");
        this.panel3.add((Component)this.label1, null);
        this.panel3.add((Component)this.txtTaille, null);
        this.panel3.add((Component)this.label2, null);
        this.panel3.add((Component)this.txtCouleurs, null);
        this.panel3.add((Component)this.label3, null);
        this.panel3.add((Component)this.txtIterations, null);
        this.panel3.add((Component)this.label4, null);
        this.panel3.add((Component)this.txtEta0, null);
        this.panel3.add((Component)this.label5, null);
        this.panel3.add((Component)this.txtSigma0, null);
        this.panel3.add((Component)this.btnModif, null);
        this.panelVue.add((Component)this.processSOM.somVue, null);
        this.initParam();
        this.processSOM.initReseau();
    }

    void btnReset_actionPerformed(ActionEvent actionEvent) {
        if (this.processSOM.isRunning) {
            this.btnGo.setLabel("GO");
            this.processSOM.stop();
            this.setInterface(true);
            this.processSOM.reInit();
            this.processSOM.lancement();
            this.btnGo.setLabel("Stop");
        } else {
            this.initParam();
            this.processSOM.reInit();
            this.affGeneration();
        }
    }

    void btnGo_actionPerformed(ActionEvent actionEvent) {
        this.stopGo();
    }

    public void stopGo() {
        if (!this.processSOM.isRunning) {
            this.btnGo.setLabel("Stop");
            this.setInterface(false);
            this.processSOM.lancement();
        } else {
            this.btnGo.setLabel("GO");
            this.processSOM.stop();
            this.setInterface(true);
        }
    }

    void btnPas_actionPerformed(ActionEvent actionEvent) {
        this.processSOM.leReseau.affRes();
    }

    void btnAbout_actionPerformed(ActionEvent actionEvent) {
        this.dispInfoBox();
    }

    @Override
    public void setInterface(boolean bl) {
        this.btnReset.setEnabled(bl);
        this.btnPas.setEnabled(bl);
        this.btnAbout.setEnabled(bl);
        this.btnModif.setEnabled(bl);
    }

    @Override
    public void affGeneration() {
        this.statusBar.setText(" It\u00e9ration :" + Integer.toString(this.processSOM.generation));
    }

    void panelVue_componentResized(ComponentEvent componentEvent) {
        this.redimUi();
    }

    void dispInfoBox() {
        String string = this.applet.product + "\n" + "Version : " + this.applet.version + ", " + this.applet.date + "\n\n" + this.applet.comments + "\n" + this.applet.auteur + "\n" + this.applet.editeur + "\n" + this.applet.copyright + "\n\n" + this.applet.GNU1 + "\n" + this.applet.GNU2 + "\n" + this.applet.GNU3 + "\n";
        CaboutBox caboutBox = new CaboutBox(this, "Classification des couleurs", true);
        caboutBox.dispInfoBox(string);
    }

    public void initParam() {
        String string = "Certains param\u00e8tres n'\u00e9taient pas corrects. Ils ont \u00e9t\u00e9 remplac\u00e9s par la valeur par d\u00e9faut.";
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        double d = 0.0;
        try {
            n = Integer.parseInt(this.txtTaille.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (n <= 0 || n > 100) {
            bl = false;
        }
        if (!bl) {
            this.txtTaille.setText(Integer.toString(ReseauSOMColor.TAILLE_DEF));
            n = ReseauSOMColor.TAILLE_DEF;
            bl2 = false;
        }
        this.tailleReseau = n;
        bl = true;
        try {
            n = Integer.parseInt(this.txtIterations.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (n <= 0 || n > 100000) {
            bl = false;
        }
        if (!bl) {
            this.txtIterations.setText(Integer.toString(ReseauSOMColor.MAX_ITER_DEF));
            n = ReseauSOMColor.MAX_ITER_DEF;
            bl2 = false;
        }
        this.maxIterations = n;
        bl = true;
        try {
            n = Integer.parseInt(this.txtCouleurs.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (n <= 0 || n > 20) {
            bl = false;
        }
        if (!bl) {
            this.txtCouleurs.setText(Integer.toString(ReseauSOMColor.NB_COL_DEF));
            n = ReseauSOMColor.NB_COL_DEF;
            bl2 = false;
        }
        this.nbCouleurs = n;
        bl = true;
        try {
            d = Double.valueOf(this.txtEta0.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (d <= 0.0 || d > 1.0) {
            bl = false;
        }
        if (!bl) {
            this.txtEta0.setText(Double.toString(ReseauSOMColor.ETA0_DEF));
            d = ReseauSOMColor.ETA0_DEF;
            bl2 = false;
        }
        this.eta0 = d;
        bl = true;
        try {
            d = Double.valueOf(this.txtSigma0.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (d <= 0.0 || d > 1.0) {
            bl = false;
        }
        if (!bl) {
            this.txtSigma0.setText(Double.toString(ReseauSOMColor.SIGMA0_DEF));
            d = ReseauSOMColor.SIGMA0_DEF;
            bl2 = false;
        }
        this.sigma0 = d;
        if (!bl2) {
            Calert calert = new Calert((Frame)this, string);
        }
    }

    void btnModif_actionPerformed(ActionEvent actionEvent) {
        if (this.btnModif.getLabel() == "Modif.") {
            this.btnModif.setLabel("Valide");
            this.txtTaille.setEnabled(true);
            this.txtIterations.setEnabled(true);
            this.txtCouleurs.setEnabled(true);
            this.txtEta0.setEnabled(true);
            this.txtSigma0.setEnabled(true);
            this.btnReset.setEnabled(false);
            this.btnPas.setEnabled(false);
            this.btnGo.setEnabled(false);
            this.btnAbout.setEnabled(false);
        } else {
            this.btnModif.setLabel("Modif.");
            this.txtTaille.setEnabled(false);
            this.txtIterations.setEnabled(false);
            this.txtCouleurs.setEnabled(false);
            this.txtEta0.setEnabled(false);
            this.txtSigma0.setEnabled(false);
            this.btnReset.setEnabled(true);
            this.btnPas.setEnabled(true);
            this.btnGo.setEnabled(true);
            this.btnAbout.setEnabled(true);
            this.initParam();
            this.processSOM.reInit();
            this.affGeneration();
        }
    }
}

