/*
 * Decompiled with CFR 0.152.
 */
package somcolorapp;

import java.awt.Color;
import java.util.Vector;
import neuronespack.Connexions;
import neuronespack.NeuroneKoho;
import neuronespack.ReseauKoho;
import somcolorapp.SOMColorProcess;

public class ReseauSOMColor
extends ReseauKoho {
    public static int TAILLE_DEF = 16;
    public static int MAX_ITER_DEF = 1500;
    public static int NB_COL_DEF = 6;
    public static double ETA0_DEF = 0.1;
    public static double SIGMA0_DEF = 0.9;
    SOMColorProcess processSOM;
    int nbCouleurs;
    Color[] paletteExemple;
    static Vector listeCol;

    public ReseauSOMColor(SOMColorProcess sOMColorProcess, int n, int n2, int n3, double d, double d2) {
        this.setDonneesCourantes(3, 1);
        this.setResultat(1);
        this.processSOM = sOMColorProcess;
        this.setDonneesCourantes(3, n * n);
        this.setResultat(n * n);
        this.setEta0(d);
        this.setSigma0((double)n * d2);
        this.construitReseau(n, n);
        boolean[][] blArray = new boolean[3][n * n];
        Connexions.construitConnexionsCompletes(3, n * n, blArray);
        this.construitConnexionsEntrees();
        this.setMaxIteration(n2);
        this.setTau();
        this.numIteration = 0;
        int n4 = n3;
        this.nbCouleurs = (int)Math.pow(n4, 3.0);
        this.paletteExemple = new Color[this.nbCouleurs];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n4; ++k) {
                    this.paletteExemple[i * n4 * n4 + j * n4 + k] = new Color((float)i / (float)(n4 - 1), (float)j / (float)(n4 - 1), (float)k / (float)(n4 - 1));
                }
            }
        }
        this.initListeCol();
    }

    void initListeCol() {
        listeCol = new Vector(this.nbCouleurs);
        for (int i = 0; i < this.nbCouleurs; ++i) {
            listeCol.addElement(this.paletteExemple[i]);
        }
    }

    public void affRes() {
        this.processSOM.somVue.afficheFond();
        double[] dArray = new double[3];
        for (int i = 0; i < this.nbCouleurs; ++i) {
            dArray[0] = (float)this.paletteExemple[i].getRed() / 255.0f;
            dArray[1] = (float)this.paletteExemple[i].getGreen() / 255.0f;
            dArray[2] = (float)this.paletteExemple[i].getBlue() / 255.0f;
            this.getDonneesCourantes().setVecteurEntree(dArray);
            this.propagation();
            this.processSOM.somVue.afficheCellule((int)this.getBMU().getPosX(), (int)this.getBMU().getPosY(), this.paletteExemple[i]);
        }
        this.processSOM.somVue.repaint();
    }

    public void epoque() {
        double[] dArray = new double[3];
        int n = (int)(Math.random() * (double)listeCol.size());
        Color color = (Color)listeCol.elementAt(n);
        dArray[0] = (float)color.getRed() / 255.0f;
        dArray[1] = (float)color.getGreen() / 255.0f;
        dArray[2] = (float)color.getBlue() / 255.0f;
        listeCol.removeElementAt(n);
        this.getDonneesCourantes().setVecteurEntree(dArray);
        this.apprend();
        ++this.numIteration;
        if (listeCol.size() == 0) {
            this.initListeCol();
        }
    }

    public Color getCouleurNeurone(int n, int n2) {
        NeuroneKoho neuroneKoho = this.getNeuroneXY(n, n2);
        float f = (float)neuroneKoho.getSynapseIn(0).getPoids();
        float f2 = (float)neuroneKoho.getSynapseIn(1).getPoids();
        float f3 = (float)neuroneKoho.getSynapseIn(2).getPoids();
        return new Color(f, f2, f3);
    }
}

