/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import neuronespack.Connexions;
import neuronespack.GroupeUnites;
import neuronespack.Reseau;
import neuronespack.Unite;
import neuronespack.UniteExterne;

public class Resultats
implements GroupeUnites {
    public static String newLine = System.getProperty("line.separator");
    public static final char SEPARATEUR = ';';
    private int tailleVecteurSortie;
    private double[] vecteurSortie;
    private Vector lesUnites;
    private FileWriter fichierResultats;

    public Resultats(int n) {
        this.tailleVecteurSortie = n;
        this.vecteurSortie = new double[this.tailleVecteurSortie];
        this.lesUnites = new Vector(this.tailleVecteurSortie);
        for (int i = 0; i < this.tailleVecteurSortie; ++i) {
            this.lesUnites.addElement(new UniteExterne(i));
        }
    }

    public void setVecteurResultat(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Connexions connexions = (Connexions)vector.elementAt(i);
            if (connexions.getTypeConnexions() != Reseau.CNX_SORTIE) continue;
            for (int j = 0; j < connexions.getNbSynapses(); ++j) {
                this.vecteurSortie[n] = connexions.getSynapse(n).getUniteOrigine().getSignalBrut();
                ((UniteExterne)this.lesUnites.elementAt(n)).setSignalCourant(this.vecteurSortie[n]);
                ++n;
            }
        }
    }

    public double[] getVecteurSortie() {
        return this.vecteurSortie;
    }

    public double getValeurSortie(int n) {
        return this.vecteurSortie[n];
    }

    public int getTailleVecteurSortie() {
        return this.tailleVecteurSortie;
    }

    public void setFichierSortie(String string) {
        try {
            this.fichierResultats = new FileWriter(string);
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    public void enregistreResultats() {
        for (int i = 0; i < this.tailleVecteurSortie; ++i) {
            this.enregistreUnResultat(i);
        }
        try {
            this.fichierResultats.write(newLine);
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    private void enregistreUnResultat(int n) {
        try {
            this.fichierResultats.write(Double.toString(this.getUnite(n).getSignalBrut()));
            this.fichierResultats.write(59);
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    public void fermeResultats() {
        try {
            this.fichierResultats.close();
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    @Override
    public Unite getUnite(int n) {
        return (Unite)this.lesUnites.elementAt(n);
    }

    @Override
    public Vector getLesUnites() {
        return this.lesUnites;
    }

    @Override
    public int getNbUnites() {
        return this.tailleVecteurSortie;
    }
}

