/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import neuronespack.Connexions;
import neuronespack.CoucheKoho;
import neuronespack.NeuroneKoho;
import neuronespack.Reseau;
import neuronespack.Synapse;

public class ReseauKoho
extends Reseau {
    private double eta0;
    private double sigma0;
    private int maxIteration;
    public int numIteration;
    private double tau;
    private NeuroneKoho bestMU = null;
    private int tailleX;
    private int tailleY;

    public ReseauKoho() {
        super(1);
    }

    public void construitReseau(int n, int n2) {
        this.tailleX = n;
        this.tailleY = n2;
        double[] dArray = new double[1];
        this.ajouteCouche(this.tailleX, this.tailleY, 1, dArray);
    }

    public void ajouteCouche(int n, int n2, int n3, double[] dArray) {
        this.addCouche(new CoucheKoho(n, n2, n3, dArray));
    }

    public void construitConnexionsEntrees() {
        boolean[][] blArray = new boolean[this.getCouche(0).getNbUnites()][this.tailleX * this.tailleY];
        Connexions.construitConnexionsCompletes(this.getDonneesCourantes().getTailleVecteurEntree(), this.tailleX * this.tailleY, blArray);
        this.construitConnexionsEntrees(blArray);
        this.getConnexions(0).setPoidsAleat(0.0, 1.0);
    }

    public void apprend() {
        this.propagation();
        this.corrigePoids();
    }

    @Override
    public void propagation() {
        this.getCouche(0).traiteCouche(this);
        this.getResultats().setVecteurResultat(this.getLesConnexions());
    }

    public void corrigePoids() {
        Connexions connexions = this.getConnexions(0);
        for (int i = 0; i < connexions.getNbSynapses(); ++i) {
            Synapse synapse = connexions.getSynapse(i);
            NeuroneKoho neuroneKoho = (NeuroneKoho)synapse.getUniteDestination();
            double d = this.getFonctionVoisinage(this.bestMU, neuroneKoho) * this.getEtaT() * (synapse.getUniteOrigine().getSignalBrut() - synapse.getPoids());
            synapse.setDeltaPoids(d);
            synapse.setPoids(synapse.getPoids() + d);
        }
    }

    private double getFonctionVoisinage(NeuroneKoho neuroneKoho, NeuroneKoho neuroneKoho2) {
        double d = ((CoucheKoho)this.getCouche(0)).getDistanceNeurones(neuroneKoho, neuroneKoho2);
        return Math.exp(-1.0 * (d * d / (2.0 * Math.pow(this.getSigmaT(), 2.0))));
    }

    public void setBMU(NeuroneKoho neuroneKoho) {
        this.bestMU = neuroneKoho;
    }

    public NeuroneKoho getBMU() {
        return this.bestMU;
    }

    public void setEta0(double d) {
        this.eta0 = d;
    }

    public double getEta0() {
        return this.eta0;
    }

    public double getEtaT() {
        return this.eta0 * Math.exp(-1.0 * (double)(this.numIteration / this.maxIteration));
    }

    public void setTau() {
        this.tau = (double)this.maxIteration / Math.log(this.sigma0);
    }

    public double getTau() {
        return this.tau;
    }

    public void setSigma0(double d) {
        this.sigma0 = d;
    }

    public double getSigma0() {
        return this.sigma0;
    }

    public double getSigmaT() {
        return this.sigma0 * Math.exp(-1.0 * ((double)this.numIteration / this.tau));
    }

    public void setMaxIteration(int n) {
        this.maxIteration = n;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public int getTailleX() {
        return this.tailleX;
    }

    public int getTailleY() {
        return this.tailleY;
    }

    public NeuroneKoho getNeuroneXY(int n, int n2) {
        if (n > this.tailleX || n2 > this.tailleY) {
            return null;
        }
        CoucheKoho coucheKoho = (CoucheKoho)this.getCouche(0);
        return (NeuroneKoho)coucheKoho.getUnite(n * this.tailleX + n2);
    }
}

