/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import java.util.Vector;
import neuronespack.Biais;
import neuronespack.Connexions;
import neuronespack.Couche;
import neuronespack.DonneesEntree;
import neuronespack.GroupeUnites;
import neuronespack.Resultats;

public abstract class Reseau {
    public static int CNX_ENTREE = 0;
    public static int CNX_SORTIE = 1;
    public static int CNX_COUCHE = 2;
    public static int CNX_BIAIS = 3;
    private int nbCouches;
    private Vector lesCouches;
    private Vector lesConnexions;
    private DonneesEntree donneesCourantes;
    private Resultats lesResultats;
    private Biais leBiais;

    public Reseau(int n) {
        this.nbCouches = n;
        this.lesCouches = new Vector(this.nbCouches);
        this.lesConnexions = new Vector();
    }

    public void addCouche(Couche couche) {
        this.lesCouches.addElement(couche);
    }

    public Couche getCouche(int n) {
        return (Couche)this.lesCouches.elementAt(n);
    }

    public Connexions construitConnexionsEntrees(boolean[][] blArray) {
        Connexions connexions = this.ajouteConnexionsEntrees(this.donneesCourantes, this.getCouche(0), blArray);
        connexions.setPoidsFixes(1.0);
        return connexions;
    }

    public Connexions construitConnexionsEntreesDirectes() {
        int n = this.donneesCourantes.getTailleVecteurEntree();
        int n2 = this.getCouche(0).getNbUnites();
        boolean[][] blArray = new boolean[n][n2];
        Connexions.construitConnexionsDirectes(n, blArray);
        return this.construitConnexionsEntrees(blArray);
    }

    public Connexions ajouteConnexionsEntrees(GroupeUnites groupeUnites, GroupeUnites groupeUnites2, boolean[][] blArray) {
        Connexions connexions = new Connexions(CNX_ENTREE, groupeUnites, groupeUnites2, blArray);
        this.lesConnexions.addElement(connexions);
        return connexions;
    }

    public Connexions construitConnexionsSorties(boolean[][] blArray) {
        Connexions connexions = this.ajouteConnexionsSorties(this.getCouche(this.nbCouches - 1), this.lesResultats, blArray);
        connexions.setPoidsFixes(1.0);
        return connexions;
    }

    public Connexions construitConnexionsSortiesDirectes() {
        int n = this.getCouche(this.nbCouches - 1).getNbUnites();
        int n2 = this.lesResultats.getNbUnites();
        boolean[][] blArray = new boolean[n][n2];
        Connexions.construitConnexionsDirectes(n, blArray);
        return this.construitConnexionsSorties(blArray);
    }

    public Connexions ajouteConnexionsSorties(GroupeUnites groupeUnites, GroupeUnites groupeUnites2, boolean[][] blArray) {
        Connexions connexions = new Connexions(CNX_SORTIE, groupeUnites, groupeUnites2, blArray);
        this.lesConnexions.addElement(connexions);
        return connexions;
    }

    public Connexions construitConnexionsCouches(GroupeUnites groupeUnites, GroupeUnites groupeUnites2, boolean[][] blArray) {
        Connexions connexions = this.ajouteConnexionsCouches(groupeUnites, groupeUnites2, blArray);
        connexions.setPoidsAleat(0.0, 1.0);
        return connexions;
    }

    public Connexions construitConnexionsCouchesComplete(GroupeUnites groupeUnites, GroupeUnites groupeUnites2) {
        int n = groupeUnites.getNbUnites();
        int n2 = groupeUnites2.getNbUnites();
        boolean[][] blArray = new boolean[n][n2];
        Connexions.construitConnexionsCompletes(n, n2, blArray);
        return this.construitConnexionsCouches(groupeUnites, groupeUnites2, blArray);
    }

    public Connexions ajouteConnexionsCouches(GroupeUnites groupeUnites, GroupeUnites groupeUnites2, boolean[][] blArray) {
        Connexions connexions = new Connexions(CNX_COUCHE, groupeUnites, groupeUnites2, blArray);
        this.lesConnexions.addElement(connexions);
        return connexions;
    }

    public void construitConnexionsBiais(double[][] dArray) {
        this.leBiais = new Biais(0);
        for (int i = 0; i < this.nbCouches; ++i) {
            this.ajouteConnexionsBiais(this.getCouche(i), dArray[i]);
        }
    }

    public void ajouteConnexionsBiais(Couche couche, double[] dArray) {
        boolean[][] blArray = new boolean[1][couche.getNbUnites()];
        double[][] dArray2 = new double[1][couche.getNbUnites()];
        for (int i = 0; i < couche.getNbUnites(); ++i) {
            blArray[0][i] = true;
            dArray2[0][i] = dArray[i];
        }
        Connexions connexions = new Connexions(CNX_BIAIS, this.leBiais, couche, blArray);
        connexions.setMatricePoids(dArray2);
        this.lesConnexions.addElement(connexions);
    }

    public void setPoidsConnexions(Connexions connexions, double[][] dArray) {
        connexions.setMatricePoids(dArray);
    }

    public int getNbCouches() {
        return this.nbCouches;
    }

    public Vector getLesCouches() {
        return this.lesCouches;
    }

    public Connexions getConnexions(int n) {
        return (Connexions)this.lesConnexions.elementAt(n);
    }

    public Vector getLesConnexions() {
        return this.lesConnexions;
    }

    public Biais getLeBiais() {
        return this.leBiais;
    }

    public void setDonneesCourantes(int n, int n2) {
        this.donneesCourantes = new DonneesEntree(n, n2);
    }

    public DonneesEntree getDonneesCourantes() {
        return this.donneesCourantes;
    }

    public void setResultat(int n) {
        this.lesResultats = new Resultats(n);
    }

    public Resultats getResultats() {
        return this.lesResultats;
    }

    public void setFichierEntree(DonneesEntree donneesEntree, String string) {
        donneesEntree.setFichierEntree(string);
    }

    public void setFichierResultat(Resultats resultats, String string) {
        resultats.setFichierSortie(string);
    }

    public abstract void propagation();
}

