/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import neuronespack.Couche;
import neuronespack.Neurone;
import neuronespack.Synapse;

public class NeuroneKoho
extends Neurone {
    public static final int POS_X = 2;
    public static final int POS_Y = 3;

    public NeuroneKoho(Couche couche, int n, int n2, int n3) {
        super(couche, n, 4);
        this.setParametreNeurone(2, n2);
        this.setParametreNeurone(3, n3);
        this.setPotentiel(-1.0);
    }

    @Override
    public double calcPotentiel() {
        double d = 0.0;
        for (int i = 0; i < this.getNbSynapsesIn(); ++i) {
            Synapse synapse = this.getSynapseIn(i);
            d += (synapse.getUniteOrigine().getSignalBrut() - synapse.getPoids()) * (synapse.getUniteOrigine().getSignalBrut() - synapse.getPoids());
        }
        return Math.sqrt(d);
    }

    public double getPosX() {
        return this.getParametreNeurone(2);
    }

    public double getPosY() {
        return this.getParametreNeurone(3);
    }

    @Override
    public void run() {
        this.setSignal(-1.0);
        this.setPotentiel(this.calcPotentiel());
    }
}

