/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import java.util.Vector;
import neuronespack.Couche;
import neuronespack.FonctionTransfert;
import neuronespack.Synapse;
import neuronespack.Unite;

public abstract class Neurone
implements Unite {
    public static final int VALEUR_SIGNAL = 0;
    public static final int VALEUR_POTENTIEL = 1;
    private int nbParametresNeurone;
    private double[] parametreNeurone;
    private int nbSynapsesIn;
    private int nbSynapsesOut;
    private Vector synapsesIn;
    private Vector synapsesOut;
    private int idNeurone;
    private Couche maCouche;

    public Neurone(Couche couche, int n, int n2) {
        this.maCouche = couche;
        this.idNeurone = n;
        this.nbParametresNeurone = n2;
        this.parametreNeurone = new double[this.nbParametresNeurone];
        this.nbSynapsesIn = 0;
        this.nbSynapsesOut = 0;
        this.synapsesIn = new Vector(this.nbSynapsesIn);
        this.synapsesOut = new Vector(this.nbSynapsesOut);
    }

    @Override
    public void addSynapsesIn(Synapse synapse) {
        ++this.nbSynapsesIn;
        this.synapsesIn.addElement(synapse);
    }

    @Override
    public void addSynapsesOut(Synapse synapse) {
        ++this.nbSynapsesOut;
        this.synapsesOut.addElement(synapse);
    }

    public Synapse getSynapseIn(int n) {
        return (Synapse)this.synapsesIn.elementAt(n);
    }

    public Synapse getSynapseOut(int n) {
        return (Synapse)this.synapsesOut.elementAt(n);
    }

    public int getNbSynapsesIn() {
        return this.nbSynapsesIn;
    }

    public int getNbSynapsesOut() {
        return this.nbSynapsesOut;
    }

    public void setPotentiel(double d) {
        this.parametreNeurone[1] = d;
    }

    public double getPotentiel() {
        return this.parametreNeurone[1];
    }

    public double calcPotentiel() {
        double d = 0.0;
        for (int i = 0; i < this.nbSynapsesIn; ++i) {
            d += ((Synapse)this.synapsesIn.elementAt(i)).getValeurSynapse();
        }
        return d;
    }

    public void setSignal(double d) {
        this.parametreNeurone[0] = d;
    }

    @Override
    public double getSignalBrut() {
        return this.parametreNeurone[0];
    }

    public double calcSignal() {
        return FonctionTransfert.calcTransfert(this.maCouche.getTypeFT(), this.parametreNeurone[1], this.maCouche.getParamFT());
    }

    @Override
    public int getID() {
        return this.idNeurone;
    }

    public double getParametreNeurone(int n) {
        return this.parametreNeurone[n];
    }

    public void setParametreNeurone(int n, double d) {
        this.parametreNeurone[n] = d;
    }

    public Couche getMaCouche() {
        return this.maCouche;
    }

    public abstract void run();
}

