/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

public class FonctionTransfert {
    public static final int F_LINEAIRE = 0;
    public static final int F_SIGNE = 1;
    public static final int F_BIPOLAIRE = 2;
    public static final int F_LOGISTIQUE = 3;
    public static final int F_TANH = 4;

    public static double calcTransfert(int n, double d, double[] dArray) {
        switch (n) {
            case 1: {
                return FonctionTransfert.fonctionSigne(d);
            }
            case 2: {
                return FonctionTransfert.fonctionBipolaire(d);
            }
            case 3: {
                return FonctionTransfert.fonctionLogistique(d);
            }
            case 4: {
                return FonctionTransfert.fonctionTangenteHyperbolique(d);
            }
        }
        return FonctionTransfert.fonctionLineaire(d, dArray);
    }

    public static double calcDerivee(int n, double d, double[] dArray) {
        switch (n) {
            case 0: {
                return dArray[0];
            }
            case 3: {
                double d2 = FonctionTransfert.fonctionLogistique(d);
                return d2 * (1.0 - d2);
            }
            case 4: {
                return 4.0 / Math.pow(Math.exp(d) + Math.exp(-1.0 * d), 2.0);
            }
        }
        return 1.0;
    }

    private static double fonctionLineaire(double d, double[] dArray) {
        return dArray[0] * d;
    }

    private static double fonctionSigne(double d) {
        return d < 0.0 ? 0.0 : 1.0;
    }

    private static double fonctionBipolaire(double d) {
        return d < 0.0 ? -1.0 : 1.0;
    }

    private static double fonctionLogistique(double d) {
        return 1.0 / (1.0 + Math.exp(-1.0 * d));
    }

    private static double fonctionTangenteHyperbolique(double d) {
        return (Math.exp(d) - Math.exp(-1.0 * d)) / (Math.exp(d) + Math.exp(-1.0 * d));
    }

    public static int getNbParametre(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public static double getRandom(double d, double d2) {
        if (d == 0.0 && d2 == 1.0) {
            return Math.random();
        }
        if (d == -1.0 && d2 == 1.0) {
            return (Math.random() > 0.5 ? -1.0 : 1.0) * Math.random();
        }
        if (d >= 0.0 && d2 >= 0.0) {
            return d + (d2 - d) * Math.random();
        }
        if (d <= 0.0 && d2 < 0.0) {
            return d2 - Math.abs(d - d2) * Math.random();
        }
        return d + (d2 - d) * Math.random();
    }
}

