/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import neuronespack.GroupeUnites;
import neuronespack.Unite;
import neuronespack.UniteExterne;

public class DonneesEntree
implements GroupeUnites {
    public static final char SEPARATEUR = ';';
    private int tailleVecteurEntree;
    private double[] vecteurEntree;
    private int tailleVecteurSortie;
    private double[] vecteurSortieDesire;
    private Vector lesUnites;
    protected FileReader fichierEntrees;
    private int posCrt = 0;

    public DonneesEntree(int n, int n2) {
        this.tailleVecteurEntree = n;
        this.tailleVecteurSortie = n2;
        this.vecteurEntree = new double[this.tailleVecteurEntree];
        this.lesUnites = new Vector(this.tailleVecteurEntree);
        for (int i = 0; i < this.tailleVecteurEntree; ++i) {
            this.lesUnites.addElement(new UniteExterne(i));
        }
        this.vecteurSortieDesire = new double[this.tailleVecteurSortie];
    }

    public void setVecteurEntree(double[] dArray) {
        for (int i = 0; i < this.tailleVecteurEntree; ++i) {
            this.vecteurEntree[i] = dArray[i];
            ((UniteExterne)this.lesUnites.elementAt(i)).setSignalCourant(this.vecteurEntree[i]);
        }
    }

    public double[] getVecteurEntree() {
        return this.vecteurEntree;
    }

    public double getValeurEntree(int n) {
        return this.vecteurEntree[n];
    }

    public int getTailleVecteurEntree() {
        return this.tailleVecteurEntree;
    }

    public void setFichierEntree(String string) {
        if (this.fichierEntrees != null) {
            this.fermeFichierDonnees();
        }
        try {
            this.fichierEntrees = new FileReader(string);
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    public void setVecteurSortieDesire(double[] dArray) {
        for (int i = 0; i < this.tailleVecteurSortie; ++i) {
            this.vecteurSortieDesire[i] = dArray[i];
        }
    }

    public double[] getVecteurSortieDesiree() {
        return this.vecteurSortieDesire;
    }

    public double getValeurSortieDesiree(int n) {
        return this.vecteurSortieDesire[n];
    }

    public int getTailleVecteurSortie() {
        return this.tailleVecteurSortie;
    }

    public void litEntreeSuivante() {
        this.litVecteurEntree();
    }

    public void litExempleSuivant() {
        this.litVecteurEntree();
        this.litVecteurSortieDesire();
    }

    private void litVecteurEntree() {
        ++this.posCrt;
        for (int i = 0; i < this.tailleVecteurEntree; ++i) {
            this.vecteurEntree[i] = this.litVal();
            ((UniteExterne)this.lesUnites.elementAt(i)).setSignalCourant(this.vecteurEntree[i]);
        }
    }

    private void litVecteurSortieDesire() {
        for (int i = 0; i < this.tailleVecteurSortie; ++i) {
            this.vecteurSortieDesire[i] = this.litVal();
        }
    }

    private double litVal() {
        char c = '_';
        String string = "";
        try {
            c = (char)this.fichierEntrees.read();
            while (c != ';') {
                if (c != '\n' && c != '\r') {
                    string = string + c;
                }
                c = (char)this.fichierEntrees.read();
            }
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
        return Double.valueOf(string);
    }

    private void reInitFichier() {
        try {
            this.fichierEntrees.reset();
            this.posCrt = 0;
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    public void fermeFichierDonnees() {
        try {
            this.fichierEntrees.close();
        }
        catch (IOException iOException) {
            System.out.println("Erreur fichier : " + iOException.toString());
        }
    }

    @Override
    public Unite getUnite(int n) {
        return (Unite)this.lesUnites.elementAt(n);
    }

    @Override
    public Vector getLesUnites() {
        return this.lesUnites;
    }

    @Override
    public int getNbUnites() {
        return this.tailleVecteurEntree;
    }
}

