/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import neuronespack.Couche;
import neuronespack.Neurone;
import neuronespack.NeuroneKoho;
import neuronespack.Reseau;
import neuronespack.ReseauKoho;

public class CoucheKoho
extends Couche {
    private int nbNeuronesX;
    private int nbNeuronesY;

    public CoucheKoho(int n, int n2, int n3, double[] dArray) {
        super(n * n2, n3, dArray);
        this.nbNeuronesX = n;
        this.nbNeuronesY = n2;
        this.creeNeurones();
    }

    @Override
    public void creeNeurones() {
        for (int i = 0; i < this.nbNeuronesX; ++i) {
            for (int j = 0; j < this.nbNeuronesX; ++j) {
                this.addNeurone(new NeuroneKoho(this, i * this.nbNeuronesX + j, i, j));
            }
        }
    }

    @Override
    public void traiteCouche(Reseau reseau) {
        Neurone neurone = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.getNbUnites(); ++i) {
            NeuroneKoho neuroneKoho = (NeuroneKoho)this.getUnite(i);
            neuroneKoho.run();
            if (!(neuroneKoho.getPotentiel() < d)) continue;
            d = neuroneKoho.getPotentiel();
            neurone = neuroneKoho;
        }
        neurone.setSignal(1.0);
        ((ReseauKoho)reseau).setBMU((NeuroneKoho)neurone);
    }

    public double getDistanceNeurones(NeuroneKoho neuroneKoho, NeuroneKoho neuroneKoho2) {
        return Math.sqrt((neuroneKoho.getPosX() - neuroneKoho2.getPosX()) * (neuroneKoho.getPosX() - neuroneKoho2.getPosX()) + (neuroneKoho.getPosY() - neuroneKoho2.getPosY()) * (neuroneKoho.getPosY() - neuroneKoho2.getPosY()));
    }

    public int getNbNeuronesX() {
        return this.nbNeuronesX;
    }

    public int getNbNeuronesY() {
        return this.nbNeuronesY;
    }
}

