/*
 * Decompiled with CFR 0.152.
 */
package neuronespack;

import java.util.Vector;
import neuronespack.FonctionTransfert;
import neuronespack.GroupeUnites;
import neuronespack.Synapse;

public class Connexions {
    protected double[][] matricePoids;
    protected double[][] matriceDeltaPoids;
    private Vector lesSynapses;
    private int nbSynapses;
    private int nbUnitesEmettrices;
    private int nbUnitesReceptrices;
    private GroupeUnites groupeOrigineConnexions;
    private GroupeUnites groupeDestinationConnexions;
    private int typeConnexions;

    public Connexions(int n, GroupeUnites groupeUnites, GroupeUnites groupeUnites2, boolean[][] blArray) {
        this.setTypeConnexions(n);
        this.nbUnitesEmettrices = groupeUnites.getNbUnites();
        this.nbUnitesReceptrices = groupeUnites2.getNbUnites();
        this.nbSynapses = this.getNbConnexions(blArray);
        this.lesSynapses = new Vector(this.nbSynapses);
        this.setGroupeOrigineConnexions(groupeUnites);
        this.setGroupeDestinationConnexions(groupeUnites2);
        this.matricePoids = new double[this.nbUnitesEmettrices][this.nbUnitesReceptrices];
        this.matriceDeltaPoids = new double[this.nbUnitesEmettrices][this.nbUnitesReceptrices];
        this.connecte(blArray);
    }

    public void connecte(boolean[][] blArray) {
        for (int i = 0; i < this.getNbUnitesEmettrices(); ++i) {
            for (int j = 0; j < this.getNbUnitesReceptrices(); ++j) {
                if (!this.sontConnecte(blArray, i, j)) continue;
                Synapse synapse = new Synapse(this);
                synapse.connecteUniteDeA(this.getGroupeOrigineConnexions().getUnite(i), this.getGroupeDestinationConnexions().getUnite(j));
                this.addSynapse(synapse);
            }
        }
    }

    public void setMatricePoids(double[][] dArray) {
        this.matricePoids = dArray;
    }

    public void setPoids(int n, int n2, double d) {
        this.matricePoids[n][n2] = d;
    }

    public void setPoidsAleat(double d, double d2) {
        for (int i = 0; i < this.nbSynapses; ++i) {
            ((Synapse)this.lesSynapses.elementAt(i)).setPoids(FonctionTransfert.getRandom(d, d2));
        }
    }

    public void setPoidsFixes(double d) {
        for (int i = 0; i < this.nbSynapses; ++i) {
            ((Synapse)this.lesSynapses.elementAt(i)).setPoids(d);
        }
    }

    public void addSynapse(Synapse synapse) {
        this.lesSynapses.addElement(synapse);
    }

    public Synapse getSynapse(int n) {
        return (Synapse)this.lesSynapses.elementAt(n);
    }

    public int getNbSynapses() {
        return this.nbSynapses;
    }

    private int getNbConnexions(boolean[][] blArray) {
        int n = 0;
        for (int i = 0; i < this.nbUnitesEmettrices; ++i) {
            for (int j = 0; j < this.nbUnitesReceptrices; ++j) {
                if (!this.sontConnecte(blArray, i, j)) continue;
                ++n;
            }
        }
        return n;
    }

    public void setTypeConnexions(int n) {
        this.typeConnexions = n;
    }

    public int getTypeConnexions() {
        return this.typeConnexions;
    }

    public int getNbUnitesEmettrices() {
        return this.nbUnitesEmettrices;
    }

    public int getNbUnitesReceptrices() {
        return this.nbUnitesReceptrices;
    }

    public void setGroupeOrigineConnexions(GroupeUnites groupeUnites) {
        this.groupeOrigineConnexions = groupeUnites;
    }

    public GroupeUnites getGroupeOrigineConnexions() {
        return this.groupeOrigineConnexions;
    }

    public void setGroupeDestinationConnexions(GroupeUnites groupeUnites) {
        this.groupeDestinationConnexions = groupeUnites;
    }

    public GroupeUnites getGroupeDestinationConnexions() {
        return this.groupeDestinationConnexions;
    }

    public double getPoids(int n, int n2) {
        return this.matricePoids[n][n2];
    }

    public double getDeltaPoids(int n, int n2) {
        return this.matriceDeltaPoids[n][n2];
    }

    public boolean sontConnecte(boolean[][] blArray, int n, int n2) {
        return blArray[n][n2];
    }

    public static void construitConnexionsCompletes(int n, int n2, boolean[][] blArray) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                blArray[i][j] = true;
            }
        }
    }

    public static void construitConnexionsDirectes(int n, boolean[][] blArray) {
        for (int i = 0; i < n; ++i) {
            blArray[i][i] = true;
        }
    }
}

